/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public abstract class ChallengeSerializer<T extends Challenge> {
    public abstract T deserialize(JsonObject var1);

    public static ProgressFormatter readFormatter(JsonObject object, ProgressFormatter defaultValue) {
        if (object.has("formatter")) {
            ResourceLocation formatterId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"formatter"));
            ProgressFormatter newFormatter = (ProgressFormatter)ProgressFormatter.REGISTERED_FORMATTERS.get((Object)formatterId);
            if (newFormatter != null) {
                return newFormatter;
            }
            throw new JsonParseException("Invalid formatter: " + formatterId);
        }
        return defaultValue;
    }

    public static int readCount(JsonObject object, int defaultValue) {
        if (object.has("count")) {
            int value = GsonHelper.m_13927_((JsonObject)object, (String)"count");
            if (value < 1) {
                throw new JsonParseException("Count must be positive and greater than zero");
            }
            return value;
        }
        return defaultValue;
    }
}

